/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package com.king.training.repositories;

import org.springframework.data.repository.CrudRepository;
import com.king.training.models.User;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;
/**
 * {Insert class description here}
 * <br>
 * <br>
 * Filename: <b>UserRepository.java</b>
 * @author Giorgio de Lodi <a href="mailto:giorgio.delodi@kingsrl.com">giorgio.delodi@kingsrl.com</a>
 * @since 25-set-2018
 * @version 0.0.1
 * 
 */
@Repository
public class UserRepository {
    
    @Autowired
    private JdbcTemplate jdbcTemplate;
    
    
    public User makeFromData(ResultSet row) throws SQLException{
        User model = new User();
        model.setEmail(row.getString("email"));
        model.setId(row.getInt("id"));
        model.setName(row.getString("name"));
        model.setUsername(row.getString("username"));
        model.setPassword(row.getString("password"));
        return model;
    }
    
    public User doLogin(String username, String password){
        List<User> users;
        users = jdbcTemplate.query("SELECT id, name, email, username, password FROM users WHERE username = ? AND password = ?",
                new Object[] {username, password}, (rs,rowNum) -> makeFromData(rs));
        return users.size() > 0 ? users.get(0) : null;
    }
    
    public List<User> getAllUsers(){
        List<User> users;
        users = jdbcTemplate.query("SELECT id, name, email, username, password FROM users", (rs,rowNum) -> makeFromData(rs));
        return users;
    }
    public User getById(int id){
        List<User> users;
        users = jdbcTemplate.query("SELECT id, name, email, username, password FROM users WHERE id = ?",
                new Object[] {id}, (rs,rowNum) -> makeFromData(rs));
        return users.size() > 0 ? users.get(0) : null;
    }
    public User saveUser(User user){
        String query = "INSERT INTO users (name,email,username, password) VALUES (?,?,?,?)";
        KeyHolder holder = new GeneratedKeyHolder();
        jdbcTemplate.update(new PreparedStatementCreator() {
            @Override
            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                PreparedStatement ps = con.prepareStatement(query,new String[]{"id"});
                ps.setString(1,user.getName());
                ps.setString(2,user.getEmail());
                ps.setString(3,user.getUsername());
                ps.setString(4,user.getPassword());
                return ps;
            }
        }, holder);
        Integer result;
        result = holder.getKey().intValue();
        if(result == null){
            return null;
        }
        User u = getById(result);
        return u != null ? u : null;
        
    }
}