/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package com.king.training.controllers;

import com.king.training.models.LoginRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.king.training.models.User;
import com.king.training.repositories.UserRepository;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * {Insert class description here}
 * <br>
 * <br>
 * Filename: <b>MainController.java</b>
 * @author Giorgio de Lodi <a href="mailto:giorgio.delodi@kingsrl.com">giorgio.delodi@kingsrl.com</a>
 * @since 25-set-2018
 * @version 0.0.1
 * 
 */
@Controller    // This means that this class is a Controller
@RequestMapping(path="/users") // This means URL's start with /demo (after Application path)
public class MainController {
	@Autowired 
	private UserRepository userRepository;

	@GetMapping(path="/add") // Map ONLY GET Requests
	public @ResponseBody String addNewUser (@RequestBody User user) {
		

		userRepository.saveUser(user);
		return "Saved";
	}

	@GetMapping(path="/all")
	public @ResponseBody Iterable<User> getAllUsers() {
		// This returns a JSON or XML with the users
		return userRepository.getAllUsers();
	}
        
        @PostMapping("/login")
        public @ResponseBody User login(@RequestBody LoginRequest login){
            return userRepository.doLogin(login.getUsername(), login.getPassword());
        }
}