

import {Injectable} from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import {Observable} from 'rxjs/Observable';
 
import {User} from '../models/user.model';

const httpOptions = {
    headers: new HttpHeaders({ 'Content-Type': 'application/json' })
};
 
@Injectable()
export class UserService {
    private url = "http://localhost:8080/training";
    constructor(private http:HttpClient) {}
 
    // Uses http.get() to load data from a single API endpoint
    getAll(){
        return this.http.get<Array<User>>(this.url+"/users/all");
    }
    login(username:string, password:string){
        return this.http.post<User>(this.url+"/users/login",JSON.stringify({username: username,password:password}),httpOptions);
    }
    add(user:User){
        return this.http.post<User>(this.url+"/users/add",JSON.stringify(user),httpOptions);
    }
}

