import { Component } from '@angular/core';
import {UserService} from '../services/user.service';
import {User} from '../models/user.model';
import {Observable} from 'rxjs/Observable';
@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.css']
})
export class AppComponent {
  title = 'app';
  username:string = "giorgio";
  password:string = "giorgio";
  currentUser:User = null;
  users:Array<User>;
  constructor(private _service:UserService){
    this.listAll();
  }

  doLogin(){
    let self = this;
    this._service.login(this.username,this.password).subscribe(data => {
      self.currentUser = data;
    });
  }

  listAll(){
    let self = this;
    this._service.getAll().subscribe((data:any) => {
      self.users = data;
    },error => {
      console.log(error);
    });
  }
}
