# Welcome

We use a simple stack for the development of our application.
On this page you will find useful informations about the environments that we ususally use and their setup.

Everyone is permitted to extend/update this page.

## Summary
* [First steps](#First-steps)
* [KServices](#KServices)
* [Documentation lifecycle](#Documentation-lifecycle)
* [Development lifecycle](#Development-lifecycle)
* [Environment Preparation](#Environment-Preparation)
    * [Base environment for everyone](#Base-environment-for-everyone)
    * [Java Development](#Java-Development)
    * [.NET Development](#.NET-Development)
    * [Angular Development](#Angular-Development)
    * [Database access](#Database-access)

## First steps
You should have now an email, a username and a password.
Check your email because you should now have access to some of our systems. Remember, if needed, to complete the registration process on them.

## KServices
Here is a list of the internal services where you will have access:
- **GitLab**: [192.168.100.206](https://192.168.100.206)
- **Vpn Access (ask for it)**: Throught the FortiClient:
    >_Remote Gateway_:151.0.243.98

    >_Port_:10443
- **Owncloud**: [https://owncloud.kingsrl.com:7505](https://owncloud.kingsrl.com:7505)

## Documentation lifecycle
During your journey here with us you will have a lot of documentation, internally we share it trought owncloud.
Remember always to be synced with the cloud!

## Development lifecycle
During the development of an application we encurage to use this lifecycle.

1) **Get the repo**: If you join an already started project you will have an access to the internal gitlab repo otherwise ask for it!

2) **Prepare your environment**: we strongly encurage our developers to prepare, share and use development machine with docker. So if in your project there is already a _docker-compose.yml_ use it otherwise create one and share it in the appropriate section of the project

3) **Commit always**: remember to commit on your repo every change that you make! 

## Environment preparation
Following we have a list of the environments that we usually have.
### Base environment for everyone
This is the base environment needed
- Install [Visual Studio Code](https://code.visualstudio.com/)
- Install [NodeJs LTS](https://nodejs.org/en/)
    - Check on your shell if the installation was successfull with: ```node -v``` and ```npm -v```
- Install [MobaXterm Home Edition](https://mobaxterm.mobatek.net/download.html)
- Install [Docker Engine](https://store.docker.com/editions/community/docker-ce-desktop-windows)
    - You need to create a docker account in order to download it
- Install [FortiClient](https://forticlient.com/downloads)
- Install [Git](https://git-scm.com/downloads)
- Install [ownCloud](https://owncloud.org/download/#owncloud-desktop-client)
- Install [Insomnia](https://insomnia.rest/download/#windows)

### Java Development
For Java development this can be the base configuration
- Install the [Java development kit](https://www.oracle.com/technetwork/java/javase/downloads/jdk8-downloads-2133151.html)
- Install [Netbeans](https://netbeans.org/downloads/)
- Install [Maven](https://maven.apache.org/download.cgi)


### .NET Development
For .Net developers this can be the base configuration
- Install [Visual Studio](https://visualstudio.microsoft.com/it/thank-you-downloading-visual-studio/?sku=Community&rel=15)

### Angular Development
In order to install everything necessary to develop in Angular you will have to install it via _CLI_ so open a cmd and execute this
```npm install -g @angular/cli```

### Database access
In order to access a specific database you will need the appropriate client.

**SQLServer**
- Install [SQL Server Management Studio](https://docs.microsoft.com/en-us/sql/ssms/download-sql-server-management-studio-ssms?view=sql-server-2017)

**MYSql**
- Install [MySql Workbench](https://dev.mysql.com/downloads/workbench/)

**Oracle**
- Install [SqlDeveloper](https://www.oracle.com/technetwork/developer-tools/sql-developer/downloads/index.html)

**PostgreSql**
- Install [PGAdmin](https://www.pgadmin.org/download/)


